﻿
// ImageProDoc.cpp: CImageProDoc 클래스의 구현
//

#include "pch.h"
#include "framework.h"
// SHARED_HANDLERS는 미리 보기, 축소판 그림 및 검색 필터 처리기를 구현하는 ATL 프로젝트에서 정의할 수 있으며
// 해당 프로젝트와 문서 코드를 공유하도록 해 줍니다.
#ifndef SHARED_HANDLERS
#include "ImagePro.h"
#endif

#include "ImageProDoc.h"

#include <propkey.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CImageProDoc

IMPLEMENT_DYNCREATE(CImageProDoc, CDocument)

BEGIN_MESSAGE_MAP(CImageProDoc, CDocument)
END_MESSAGE_MAP()


// CImageProDoc 생성/소멸

CImageProDoc::CImageProDoc() noexcept
{
	// TODO: 여기에 일회성 생성 코드를 추가합니다.

}

CImageProDoc::~CImageProDoc()
{
}

void CImageProDoc::PixelAdd()
{
	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x) {
			int value = inputImg[y][x] + 100;

			resultImg[y][x] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProDoc::PixelHistoEq()
{
	int hist[256];

	for (int i = 0; i < 256; ++i)
		hist[i] = 0;

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x)
			++hist[inputImg[y][x]];
	}

	int sum[256] = { hist[0], };

	for (int i = 1; i < 256; ++i)
		sum[i] = sum[i - 1] + hist[i];

	constexpr double N = 256 * 256;

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x)
			resultImg[y][x] = unsigned char(sum[inputImg[y][x]] / N * 255);
	}
}

void CImageProDoc::PixelStretchIntensity()
{
	int min = 256;
	int max = 0;

	for (int i = 0; i < 256; ++i) {
		for (int j = 0; j < 256; ++j) {
			if (min > inputImg[i][j])
				min = inputImg[i][j];

			if (max < inputImg[i][j])
				max = inputImg[i][j];
		}
	}

	if (min == max) {
		for (int i = 0; i < 256; ++i) {
			for (int j = 0; j < 256; ++j)
				resultImg[i][j] = 255;
		}
	}
	else {
		double coeff = 255.0 / (max - min);

		for (int i = 0; i < 256; ++i) {
			for (int j = 0; j < 256; ++j)
				resultImg[i][j] = static_cast<unsigned char>((inputImg[i][j] - min) * coeff);
		}
	}
}

void CImageProDoc::PixelTwoImageAdd()
{
	LoadTwoImages();

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x){
			int value = inputImg[y][x] + inputImg2[y][x];

			resultImg[y][x] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProDoc::PixelTwoImageSubtract()
{
	LoadTwoImages();

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x) {
			int value = inputImg[y][x] - inputImg2[y][x];

			resultImg[y][x] = (value >= 0 ? value : 0);
		}
	}
}

void CImageProDoc::PixelTwoImageSubtract_security()
{
	load_simple_pgm(inputImg, 256, 256);
	load_simple_pgm(inputImg2, 256, 256);

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x) {
			int value = inputImg[y][x] - inputImg2[y][x];
			value *= value;
			//value = abs(value);

			resultImg[y][x] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProDoc::PixelTwoImageMultiply()
{
	LoadTwoImages();

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x) {
			int value = inputImg[y][x] * inputImg2[y][x];

			resultImg[y][x] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProDoc::PixelTwoImageDivide()
{
	LoadTwoImages();

	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x)
			resultImg[y][x] = (inputImg2[y][x] == 0 ? 255 : inputImg[y][x] / inputImg2[y][x]);
	}
}

void CImageProDoc::LoadTwoImages()
{
	CFileDialog dlg(TRUE);

	AfxMessageBox(_T("Select the First Image"));

	if (dlg.DoModal() == IDOK) {
		CFile file;

		if (file.Open(dlg.GetPathName(), CFile::modeRead) != 0) {
			file.Read(inputImg, 256 * 256);
			file.Close();
		}
	}

	AfxMessageBox(_T("Select the Second Image"));

	if (dlg.DoModal() == IDOK) {
		CFile file;

		if (file.Open(dlg.GetPathName(), CFile::modeRead) != 0) {
			file.Read(inputImg2, 256 * 256);
			file.Close();
		}
	}
}

void CImageProDoc::PixelBinary()
{
	for (int i = 0; i < 256; ++i) {
		for (int j = 0; j < 256; ++j)
			resultImg[i][j] = (inputImg[i][j] >= 50 ? 255 : 0);
	}
}

void CImageProDoc::PixelReverse()
{
	for (int i = 0; i < 256; ++i) {
		for (int j = 0; j < 256; ++j)
			resultImg[i][j] = 255 - inputImg[i][j];
	}
}

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
using namespace std;

void CImageProDoc::LoadPgmImage(unsigned char img[][256], int n_r, int n_c)
{
	CFileDialog dlg(TRUE);
	
	AfxMessageBox(_T("Select the pgm Image"));

	if (dlg.DoModal() == IDOK) {
		string file_format;
		int size_x = 0, size_y = 0, max_intensity;

		ifstream ifs{ dlg.GetPathName() };
		string line;
		int head_count = 0;
		bool bad_file = false;
		int pixel_count = 0;

		string res;

		while (head_count < 4) {
			if (!getline(ifs, line)) {
				bad_file = true;
				break;
			}

			istringstream iss{ line };
			bool line_end = false;
			string w;

			while (iss >> w) {
				if (w[0] == '#') {
					line_end = true;
					break;
				}

				if (head_count == 0) {
					res += w;
					file_format = w;
					if (file_format != "P5")
						bad_file = true;
				}
				else if (head_count == 1) {
					res += ' ' + w;
					size_x = stoi(w);
					if (size_x == 0)
						bad_file = true;
				}
				else if (head_count == 2) {
					res += ' ' + w;
					size_y = stoi(w);
					if (size_y == 0)
						bad_file = true;
				}
				else if (head_count == 3) {
					res += ' ' + w;
					max_intensity = stoi(w);
					if (max_intensity == 0)
						bad_file = true;
				}
				//else
				//	continue;

				if (bad_file) break;

				++head_count;

				if (head_count == 4) break;
			}

			if (line_end) continue;
			if (bad_file) break;
		}

		ifs.seekg(0);
		for (int i = 0; i < 4; ++i)
			getline(ifs, line);

		int position = int(ifs.tellg());
		position -= 4;
		CString str_p;
		str_p.Format(_T("%d"), position);


		ifs.close();
		ifs.open(dlg.GetPathName(), std::ifstream::binary);
		ifs.seekg(position);

		if (bad_file)
			AfxMessageBox(_T("Bad file"));
		else
			AfxMessageBox(wstring{res.begin(), res.end()}.c_str());

		vector<vector<char>> v(size_y, vector<char>(size_x));

		//char buf[2000] = { 0 };

		for (int i = 0; i < size_y; ++i) {
			ifs.read(v[i].data(), size_x);
			//ifs.read(buf, size_x);
			if (!ifs) {
				//AfxMessageBox(_T("test"));
				//int x = i;
				CString str;
				str.Format(_T("%d"), i);
				AfxMessageBox(str);
				//ifs.read(v[i].data(), size_x);
			}
		}

		for (int i = 0; i < n_r; ++i) {
			if (i == size_y) break;

			for (int j = 0; j < n_c; ++j) {
				if (j == size_x) break;

				img[i][j] = v[i][j];
			}
		}

		//vector<char> v(size_x * size_y);
		//ifs.read(v.data(), size_x * size_y);

		//AfxMessageBox(_T("test"));



		


	}
}

void CImageProDoc::load_simple_pgm(unsigned char img[][256], int n_r, int n_c)
{
	CFileDialog dlg(TRUE);

	AfxMessageBox(_T("Select a PGM image."));

	if (dlg.DoModal() == IDOK) {
		ifstream ifs{ dlg.GetPathName() };
		string commnet_line;
		string file_format;
		int size_x, size_y, max_intensity;

		ifs >> file_format;
		ifs.ignore();
		getline(ifs, commnet_line);
		ifs >> size_x >> size_y >> max_intensity;

		ifs.seekg(0);

		string temp;

		for (int i = 0; i < 4; ++i)
			getline(ifs, temp);

		int position = int(ifs.tellg());

		position -= 4;
		
		//CString str_p;
		//str_p.Format(_T("%d"), position);

		ifs.close();
		ifs.open(dlg.GetPathName(), std::ifstream::binary);
		ifs.seekg(position);

		vector<vector<char>> v(size_y, vector<char>(size_x));

		for (int i = 0; i < size_y; ++i) {
			ifs.read(v[i].data(), size_x);

			if (!ifs) {
				CString str;

				str.Format(_T("%d"), i);
				AfxMessageBox(str);
				break;
			}
		}

		for (int i = 0; i < n_r; ++i) {
			if (i == size_y) break;

			for (int j = 0; j < n_c; ++j) {
				if (j == size_x) break;

				img[i][j] = v[i][j];
			}
		}
	}
}

void CImageProDoc::load_pgm(unsigned char img[][256], int n_r, int n_c)
{
}

BOOL CImageProDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: 여기에 재초기화 코드를 추가합니다.
	// SDI 문서는 이 문서를 다시 사용합니다.

	return TRUE;
}




// CImageProDoc serialization

void CImageProDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: 여기에 저장 코드를 추가합니다.
		ar.Write(resultImg, 256 * 256);
	}
	else
	{
		 //TODO: 여기에 로딩 코드를 추가합니다.
		CFile* fp = ar.GetFile();

		if (fp->GetLength() == 256 * 256)
			ar.Read(inputImg, 256 * 256);
		else
			AfxMessageBox(_T("256x256 크기의 파일만 사용 가능합니다."));


	}
}

#ifdef SHARED_HANDLERS

// 축소판 그림을 지원합니다.
void CImageProDoc::OnDrawThumbnail(CDC& dc, LPRECT lprcBounds)
{
	// 문서의 데이터를 그리려면 이 코드를 수정하십시오.
	dc.FillSolidRect(lprcBounds, RGB(255, 255, 255));

	CString strText = _T("TODO: implement thumbnail drawing here");
	LOGFONT lf;

	CFont* pDefaultGUIFont = CFont::FromHandle((HFONT) GetStockObject(DEFAULT_GUI_FONT));
	pDefaultGUIFont->GetLogFont(&lf);
	lf.lfHeight = 36;

	CFont fontDraw;
	fontDraw.CreateFontIndirect(&lf);

	CFont* pOldFont = dc.SelectObject(&fontDraw);
	dc.DrawText(strText, lprcBounds, DT_CENTER | DT_WORDBREAK);
	dc.SelectObject(pOldFont);
}

// 검색 처리기를 지원합니다.
void CImageProDoc::InitializeSearchContent()
{
	CString strSearchContent;
	// 문서의 데이터에서 검색 콘텐츠를 설정합니다.
	// 콘텐츠 부분은 ";"로 구분되어야 합니다.

	// 예: strSearchContent = _T("point;rectangle;circle;ole object;");
	SetSearchContent(strSearchContent);
}

void CImageProDoc::SetSearchContent(const CString& value)
{
	if (value.IsEmpty())
	{
		RemoveChunk(PKEY_Search_Contents.fmtid, PKEY_Search_Contents.pid);
	}
	else
	{
		CMFCFilterChunkValueImpl *pChunk = nullptr;
		ATLTRY(pChunk = new CMFCFilterChunkValueImpl);
		if (pChunk != nullptr)
		{
			pChunk->SetTextValue(PKEY_Search_Contents, value, CHUNK_TEXT);
			SetChunkValue(pChunk);
		}
	}
}

#endif // SHARED_HANDLERS

// CImageProDoc 진단

#ifdef _DEBUG
void CImageProDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CImageProDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CImageProDoc 명령
