﻿
// ImageProDoc.h: CImageProDoc 클래스의 인터페이스
//


#pragma once


class CImageProDoc : public CDocument
{
protected: // serialization에서만 만들어집니다.
	CImageProDoc() noexcept;
	DECLARE_DYNCREATE(CImageProDoc)

// 특성입니다.
public:
	unsigned char inputImg[256][256];
	unsigned char inputImg2[256][256];
	unsigned char resultImg[256][256];

	//unsigned char** inputImg{ nullptr };
	//unsigned char** inputImg2{ nullptr };
	//unsigned char** resultImg{ nullptr };
	//int imageWidth;
	//int imageHeight;
	//int depth;

// 작업입니다.
public:
	void PixelAdd();
	void PixelHistoEq();
	void PixelStretchIntensity();
	void PixelTwoImageAdd();
	void PixelTwoImageSubtract();
	void PixelTwoImageSubtract_security();
	void PixelTwoImageMultiply();
	void PixelTwoImageDivide();
	void LoadTwoImages();
	void PixelBinary();
	void PixelReverse();
	

	void LoadPgmImage(unsigned char img[][256], int n_r, int n_c);

	void load_simple_pgm(unsigned char img[][256], int n_r, int n_c);

	void load_pgm(unsigned char img[][256], int n_r, int n_c);


// 재정의입니다.
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
#ifdef SHARED_HANDLERS
	virtual void InitializeSearchContent();
	virtual void OnDrawThumbnail(CDC& dc, LPRECT lprcBounds);
#endif // SHARED_HANDLERS

// 구현입니다.
public:
	virtual ~CImageProDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// 생성된 메시지 맵 함수
protected:
	DECLARE_MESSAGE_MAP()

#ifdef SHARED_HANDLERS
	// 검색 처리기에 대한 검색 콘텐츠를 설정하는 도우미 함수
	void SetSearchContent(const CString& value);
#endif // SHARED_HANDLERS
};
