﻿
// ImageProView.cpp: CImageProView 클래스의 구현
//

#include "pch.h"
#include "framework.h"
// SHARED_HANDLERS는 미리 보기, 축소판 그림 및 검색 필터 처리기를 구현하는 ATL 프로젝트에서 정의할 수 있으며
// 해당 프로젝트와 문서 코드를 공유하도록 해 줍니다.
#ifndef SHARED_HANDLERS
#include "ImagePro.h"
#endif

#include "ImageProDoc.h"
#include "ImageProView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define TWO_IMAGES		1
#define THREE_IMAGES	2

// CImageProView

IMPLEMENT_DYNCREATE(CImageProView, CScrollView)

BEGIN_MESSAGE_MAP(CImageProView, CScrollView)
	// 표준 인쇄 명령입니다.
	ON_COMMAND(ID_FILE_PRINT, &CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CImageProView::OnFilePrintPreview)
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_PIXEL_ADD, &CImageProView::OnPixelAdd)
	ON_COMMAND(ID_PIXEL_HISTO_EQ, &CImageProView::OnPixelHistoEq)
	ON_COMMAND(ID_PIXEL_TWO_IMAGE_ADD, &CImageProView::OnPixelTwoImageAdd)
	ON_COMMAND(ID_PIXEL_TWO_IMAGE_SUBTRACT, &CImageProView::OnPixelTwoImageSubtract)
	ON_COMMAND(ID_PIXEL_TWO_IMAGE_MULTIPLY, &CImageProView::OnPixelTwoImageMultiply)
	ON_COMMAND(ID_PIXEL_TWO_IMAGE_DIVIDE, &CImageProView::OnPixelTwoImageDivide)
	ON_COMMAND(ID_OPEN_PGM, &CImageProView::OnOpenPgm)
	ON_COMMAND(ID_PIXEL_SECURITY_SUBTRACT, &CImageProView::OnPixelSecuritySubtract)
	ON_COMMAND(ID_PIXEL_STRETCH_INTENSITY, &CImageProView::OnPixelStretchIntensity)
	ON_COMMAND(ID_PIXEL_BINARY, &CImageProView::OnPixelBinary)
	ON_COMMAND(ID_PIXEL_REVERSE, &CImageProView::OnPixelReverse)
END_MESSAGE_MAP()

// CImageProView 생성/소멸

CImageProView::CImageProView() noexcept
{
	// TODO: 여기에 생성 코드를 추가합니다.

}

CImageProView::~CImageProView()
{
}

BOOL CImageProView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: CREATESTRUCT cs를 수정하여 여기에서
	//  Window 클래스 또는 스타일을 수정합니다.

	return CScrollView::PreCreateWindow(cs);
}

// CImageProView 그리기

void CImageProView::OnDraw(CDC* pDC)
{
	CImageProDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: 여기에 원시 데이터에 대한 그리기 코드를 추가합니다.
	for (int y = 0; y < 256; ++y) {
		for (int x = 0; x < 256; ++x)
			pDC->SetPixel(x, y, RGB(pDoc->inputImg[y][x], pDoc->inputImg[y][x], pDoc->inputImg[y][x]));
	}

	if (viewMode == THREE_IMAGES) {
		for (int y = 0; y < 256; ++y) {
			for (int x = 0; x < 256; ++x)
				pDC->SetPixel(x + 300, y, RGB(pDoc->inputImg2[y][x], pDoc->inputImg2[y][x], pDoc->inputImg2[y][x]));
		}

		for (int y = 0; y < 256; ++y) {
			for (int x = 0; x < 256; ++x)
				pDC->SetPixel(x + 600, y, RGB(pDoc->resultImg[y][x], pDoc->resultImg[y][x], pDoc->resultImg[y][x]));
		}
	}
	else {
		for (int y = 0; y < 256; ++y) {
			for (int x = 0; x < 256; ++x)
				pDC->SetPixel(x + 300, y, RGB(pDoc->resultImg[y][x], pDoc->resultImg[y][x], pDoc->resultImg[y][x]));
		}
	}
}

void CImageProView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: 이 뷰의 전체 크기를 계산합니다.
	sizeTotal.cx = 2048;
	sizeTotal.cy = 1024;
	SetScrollSizes(MM_TEXT, sizeTotal);
}


// CImageProView 인쇄


void CImageProView::OnFilePrintPreview()
{
#ifndef SHARED_HANDLERS
	AFXPrintPreview(this);
#endif
}

BOOL CImageProView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// 기본적인 준비
	return DoPreparePrinting(pInfo);
}

void CImageProView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: 인쇄하기 전에 추가 초기화 작업을 추가합니다.
}

void CImageProView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: 인쇄 후 정리 작업을 추가합니다.
}

void CImageProView::OnRButtonUp(UINT /* nFlags */, CPoint point)
{
	ClientToScreen(&point);
	OnContextMenu(this, point);
}

void CImageProView::OnContextMenu(CWnd* /* pWnd */, CPoint point)
{
#ifndef SHARED_HANDLERS
	theApp.GetContextMenuManager()->ShowPopupMenu(IDR_POPUP_EDIT, point.x, point.y, this, TRUE);
#endif
}


// CImageProView 진단

#ifdef _DEBUG
void CImageProView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CImageProView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CImageProDoc* CImageProView::GetDocument() const // 디버그되지 않은 버전은 인라인으로 지정됩니다.
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CImageProDoc)));
	return (CImageProDoc*)m_pDocument;
}
#endif //_DEBUG


// CImageProView 메시지 처리기


void CImageProView::OnPixelAdd()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelAdd();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelHistoEq()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelHistoEq();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelTwoImageAdd()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelTwoImageAdd();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelTwoImageSubtract()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelTwoImageSubtract();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelTwoImageMultiply()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelTwoImageMultiply();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelTwoImageDivide()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelTwoImageDivide();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnOpenPgm()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	//pDoc->LoadPgmImage(reinterpret_cast<unsigned char**>(pDoc->inputImg), 256, 256);
	//pDoc->LoadPgmImage(pDoc->inputImg, 256, 256);
	pDoc->load_simple_pgm(pDoc->inputImg, 256, 256);
	
	pDoc->PixelAdd();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelSecuritySubtract()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;


	pDoc->PixelTwoImageSubtract_security();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelStretchIntensity()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelStretchIntensity();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelBinary()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->load_simple_pgm(pDoc->inputImg, 256, 256);
	pDoc->PixelBinary();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProView::OnPixelReverse()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProDoc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelReverse();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}
