﻿
// ImagePro_ch3Doc.cpp: CImageProch3Doc 클래스의 구현
//

#include "pch.h"
#include "framework.h"
// SHARED_HANDLERS는 미리 보기, 축소판 그림 및 검색 필터 처리기를 구현하는 ATL 프로젝트에서 정의할 수 있으며
// 해당 프로젝트와 문서 코드를 공유하도록 해 줍니다.
#ifndef SHARED_HANDLERS
#include "ImagePro_ch3.h"
#endif

#include "ImagePro_ch3Doc.h"

#include <propkey.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CImageProch3Doc

IMPLEMENT_DYNCREATE(CImageProch3Doc, CDocument)

BEGIN_MESSAGE_MAP(CImageProch3Doc, CDocument)
END_MESSAGE_MAP()


// CImageProch3Doc 생성/소멸

CImageProch3Doc::CImageProch3Doc() noexcept
{
	// TODO: 여기에 일회성 생성 코드를 추가합니다.

}

CImageProch3Doc::~CImageProch3Doc()
{
}

void CImageProch3Doc::LoadImageFile(CArchive& ar)
{
	CFile* fp = ar.GetFile();
	CString fname = fp->GetFilePath();

	char type[16], buf[256];
	int maxValue;

	if (strcmp(strrchr(fname, '.'), ".ppm") == 0 ||
		strcmp(strrchr(fname, '.'), ".PPM") == 0 ||
		strcmp(strrchr(fname, '.'), ".pgm") == 0 ||
		strcmp(strrchr(fname, '.'), ".PGM") == 0) {
		ar.ReadString(type, 15);

		do {
			ar.ReadString(buf, 255);
		} while (buf[0] == '#');

		sscanf_s(buf, "%d %d", &imageWidth, &imageHeight);

		do {
			ar.ReadString(buf, 255);
		} while (buf[0] == '#');

		sscanf_s(buf, "%d", &maxValue);

		if (strcmp(type, "P5") == 0)
			depth = 1;
		else
			depth = 3;
	}
	else if (strcmp(strrchr(fname, '.'), ".raw") == 0 ||
		strcmp(strrchr(fname, '.'), ".RAW") == 0) {
		if (fp->GetLength() != 256 * 256) {
			AfxMessageBox("256x256 크기의 파일만 사용가능합니다.");
			return;
		}

		imageWidth = 256;
		imageHeight = 256;
		depth = 1;
	}

	inputImg = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));
	resultImg = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight; ++i) {
		inputImg[i] = (unsigned char*)malloc(imageWidth * depth);
		resultImg[i] = (unsigned char*)malloc(imageWidth * depth);
	}

	for (int i = 0; i < imageHeight; ++i)
		ar.Read(inputImg[i], imageWidth * depth);
}

void CImageProch3Doc::PixelAdd()
{
	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			int value = inputImg[i][j] + 100;

			resultImg[i][j] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProch3Doc::PixelHistoEq()
{
	int hist[256] = { 0 };

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j)
			++hist[inputImg[i][j]];
	}

	int sum[256] = { hist[0], };

	for (int i = 1; i < 256; ++i)
		sum[i] = sum[i - 1] + hist[i];

	const double N = imageWidth * imageHeight;

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j)
			resultImg[i][j] = unsigned char(sum[inputImg[i][j]] / N * 255);
	}
}

void CImageProch3Doc::PixelTwoImageAdd()
{
	LoadTwoImages();

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			int value = inputImg[i][j] + inputImg2[i][j];

			resultImg[i][j] = (value <= 255 ? value : 255);
		}
	}
}

void CImageProch3Doc::RegionSharpening()
{
	double kernel[3][3] = { {0, -1, 0},
							{-1, 5, -1},
							{0, -1, 0} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 0, depth);
}

void CImageProch3Doc::Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][3], int bias, int depth)
{
	unsigned char** tmpImg = (unsigned char**)malloc((imageHeight + 2) * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight + 2; ++i)
		tmpImg[i] = (unsigned char*)malloc((imageWidth + 2) * depth);

	for (int i = 0; i < imageHeight + 2; ++i) {
		for (int j = 0; j < imageWidth + 2; ++j)
			tmpImg[i][j] = 0;
	}

	for (int i = 1; i < imageHeight + 1; ++i) {
		for (int j = 1; j < imageWidth + 1; ++j) {
			if (depth == 1)
				tmpImg[i][j] = inputImg[i - 1][j - 1];
			else if (depth == 3) {
				tmpImg[i][3 * j] = inputImg[i - 1][3 * (j - 1)];
				tmpImg[i][3 * j + 1] = inputImg[i - 1][3 * (j - 1) + 1];
				tmpImg[i][3 * j + 2] = inputImg[i - 1][3 * (j - 1) + 2];
			}
		}
	}

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = 0;

				for (int y = 0; y < 3; ++y) {
					for (int x = 0; x < 3; ++x)
						sum += int(tmpImg[i + y][j + x] * mask[y][x]);
				}

				sum += bias;

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);

			}
			else if (depth == 3) {
				int red = 0, green = 0, blue = 0;

				for (int y = 0; y < 3; ++y) {
					for (int x = 0; x < 3; ++x) {
						red += int(tmpImg[i + y][3 * (j + x)] * mask[y][x]);
						green += int(tmpImg[i + y][3 * (j + x) + 1] * mask[y][x]);
						blue += int(tmpImg[i + y][3 * (j + x) + 2] * mask[y][x]);
					}
				}

				red += bias;
				green += bias;
				blue += bias;

				if (red > 255) red = 255;
				if (red < 0) red = 0;
				if (green > 255) green = 255;
				if (green < 0) green = 0;
				if (blue > 255) blue = 255;
				if (blue < 0) blue = 0;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}

	for (int i = 0; i < imageHeight + 2; ++i)
		free(tmpImg[i]);

	free(tmpImg);
}

void CImageProch3Doc::Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][2], int bias, int depth)
{
	unsigned char** tmpImg = (unsigned char**)malloc((imageHeight + 1) * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight + 1; ++i)
		tmpImg[i] = (unsigned char*)malloc((imageWidth + 1) * depth);

	for (int i = 0; i < imageHeight + 1; ++i) {
		for (int j = 0; j < imageWidth + 1; ++j)
			tmpImg[i][j] = 0;
	}

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1)
				tmpImg[i][j] = inputImg[i][j];
			else if (depth == 3) {
				tmpImg[i][3 * j] = inputImg[i][3 * j];
				tmpImg[i][3 * j + 1] = inputImg[i][3 * j + 1];
				tmpImg[i][3 * j + 2] = inputImg[i][3 * j + 2];
			}
		}
	}

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = 0;

				for (int y = 0; y < 2; ++y) {
					for (int x = 0; x < 2; ++x)
						sum += int(tmpImg[i + y][j + x] * mask[y][x]);
				}

				sum += bias;

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);

			}
			else if (depth == 3) {
				int red = 0, green = 0, blue = 0;

				for (int y = 0; y < 2; ++y) {
					for (int x = 0; x < 2; ++x) {
						red += int(tmpImg[i + y][3 * (j + x)] * mask[y][x]);
						green += int(tmpImg[i + y][3 * (j + x) + 1] * mask[y][x]);
						blue += int(tmpImg[i + y][3 * (j + x) + 2] * mask[y][x]);
					}
				}

				red += bias;
				green += bias;
				blue += bias;

				if (red > 255) red = 255;
				if (red < 0) red = 0;
				if (green > 255) green = 255;
				if (green < 0) green = 0;
				if (blue > 255) blue = 255;
				if (blue < 0) blue = 0;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}

	for (int i = 0; i < imageHeight + 1; ++i)
		free(tmpImg[i]);

	free(tmpImg);
}

void CImageProch3Doc::Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][5], int bias, int depth)
{
	unsigned char** tmpImg = (unsigned char**)malloc((imageHeight + 4) * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight + 4; ++i)
		tmpImg[i] = (unsigned char*)malloc((imageWidth + 4) * depth);

	for (int i = 0; i < imageHeight + 4; ++i) {
		for (int j = 0; j < imageWidth + 4; ++j)
			tmpImg[i][j] = 0;
	}

	for (int i = 2; i < imageHeight + 2; ++i) {
		for (int j = 2; j < imageWidth + 2; ++j) {
			if (depth == 1)
				tmpImg[i][j] = inputImg[i - 2][j - 2];
			else if (depth == 3) {
				tmpImg[i][3 * j] = inputImg[i - 2][3 * (j - 2)];
				tmpImg[i][3 * j + 1] = inputImg[i - 2][3 * (j - 2) + 1];
				tmpImg[i][3 * j + 2] = inputImg[i - 2][3 * (j - 2) + 2];
			}
		}
	}

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = 0;

				for (int y = 0; y < 5; ++y) {
					for (int x = 0; x < 5; ++x)
						sum += int(tmpImg[i + y][j + x] * mask[y][x]);
				}

				sum += bias;

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);

			}
			else if (depth == 3) {
				int red = 0, green = 0, blue = 0;

				for (int y = 0; y < 5; ++y) {
					for (int x = 0; x < 5; ++x) {
						red += int(tmpImg[i + y][3 * (j + x)] * mask[y][x]);
						green += int(tmpImg[i + y][3 * (j + x) + 1] * mask[y][x]);
						blue += int(tmpImg[i + y][3 * (j + x) + 2] * mask[y][x]);
					}
				}

				red += bias;
				green += bias;
				blue += bias;

				if (red > 255) red = 255;
				if (red < 0) red = 0;
				if (green > 255) green = 255;
				if (green < 0) green = 0;
				if (blue > 255) blue = 255;
				if (blue < 0) blue = 0;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}

	for (int i = 0; i < imageHeight + 4; ++i)
		free(tmpImg[i]);

	free(tmpImg);
}

void CImageProch3Doc::RegionMeaning()
{
	double kernel[3][3] = { {1 / 9.0, 1 / 9.0, 1 / 9.0},
							{1 / 9.0, 1 / 9.0, 1 / 9.0},
							{1 / 9.0, 1 / 9.0, 1 / 9.0} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 0, depth);
}

void CImageProch3Doc::RegionMedian5x5()
{
	double kernel[5][5] = { {1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0},
							{1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0},
							{1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0},
							{1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0},
							{1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0, 1 / 25.0} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 0, depth);
}

#include <cmath>

void CImageProch3Doc::RegionSobel()
{
	double mask1[3][3] = { {1, 0, -1},
							{2, 0, -2},
							{1, 0, -1} };
	double mask2[3][3] = { {-1, -2, -1},
							{0, 0, 0},
							{1, 2, 1} };

	unsigned char** Er = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));
	unsigned char** Ec = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight; ++i) {
		Er[i] = (unsigned char*)malloc(imageWidth * depth);
		Ec[i] = (unsigned char*)malloc(imageWidth * depth);
	}

	Convolve(inputImg, Er, imageWidth, imageHeight, mask1, 0, depth);
	Convolve(inputImg, Ec, imageWidth, imageHeight, mask2, 0, depth);

	
	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = int(sqrt(Er[i][j] * Er[i][j] + Ec[i][j] * Ec[i][j]));

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);
			}
			else if (depth == 3) {
				int red = int(sqrt(Er[i][3 * j] * Er[i][3 * j] + Ec[i][3 * j] * Ec[i][3 * j]));
				int green = int(sqrt(Er[i][3 * j + 1] * Er[i][3 * j + 1] + Ec[i][3 * j + 1] * Ec[i][3 * j + 1]));
				int blue = int(sqrt(Er[i][3 * j + 2] * Er[i][3 * j + 2] + Ec[i][3 * j + 2] * Ec[i][3 * j + 2]));

				if (red > 255) red = 255;
				if (green > 255) green = 255;
				if (blue > 255) blue = 255;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}
}

void CImageProch3Doc::RegionPrewitt()
{
	double mask1[3][3] = { {-1, -1, -1},
							{0, 0, 0},
							{1, 1, 1} };
	double mask2[3][3] = { {1, 0, -1},
							{1, 0, -1},
							{1, 0, -1} };

	unsigned char** Er = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));
	unsigned char** Ec = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight; ++i) {
		Er[i] = (unsigned char*)malloc(imageWidth * depth);
		Ec[i] = (unsigned char*)malloc(imageWidth * depth);
	}

	Convolve(inputImg, Er, imageWidth, imageHeight, mask1, 0, depth);
	Convolve(inputImg, Ec, imageWidth, imageHeight, mask2, 0, depth);

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = int(sqrt(Er[i][j] * Er[i][j] + Ec[i][j] * Ec[i][j]));

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);
			}
			else if (depth == 3) {
				int red = int(sqrt(Er[i][3 * j] * Er[i][3 * j] + Ec[i][3 * j] * Ec[i][3 * j]));
				int green = int(sqrt(Er[i][3 * j + 1] * Er[i][3 * j + 1] + Ec[i][3 * j + 1] * Ec[i][3 * j + 1]));
				int blue = int(sqrt(Er[i][3 * j + 2] * Er[i][3 * j + 2] + Ec[i][3 * j + 2] * Ec[i][3 * j + 2]));

				if (red > 255) red = 255;
				if (green > 255) green = 255;
				if (blue > 255) blue = 255;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}
}

void CImageProch3Doc::RegionRoberts()
{
	double mask1[2][2] = { {-1, 0},
							{0, 1} };
	double mask2[2][2] = { {0, -1},
							{1, 0} };

	unsigned char** Er = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));
	unsigned char** Ec = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight; ++i) {
		Er[i] = (unsigned char*)malloc(imageWidth * depth);
		Ec[i] = (unsigned char*)malloc(imageWidth * depth);
	}

	Convolve(inputImg, Er, imageWidth, imageHeight, mask1, 0, depth);
	Convolve(inputImg, Ec, imageWidth, imageHeight, mask2, 0, depth);

	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j) {
			if (depth == 1) {
				int sum = int(sqrt(Er[i][j] * Er[i][j] + Ec[i][j] * Ec[i][j]));

				if (sum > 255) sum = 255;
				if (sum < 0) sum = 0;

				resultImg[i][j] = unsigned char(sum);
			}
			else if (depth == 3) {
				int red = int(sqrt(Er[i][3 * j] * Er[i][3 * j] + Ec[i][3 * j] * Ec[i][3 * j]));
				int green = int(sqrt(Er[i][3 * j + 1] * Er[i][3 * j + 1] + Ec[i][3 * j + 1] * Ec[i][3 * j + 1]));
				int blue = int(sqrt(Er[i][3 * j + 2] * Er[i][3 * j + 2] + Ec[i][3 * j + 2] * Ec[i][3 * j + 2]));

				if (red > 255) red = 255;
				if (green > 255) green = 255;
				if (blue > 255) blue = 255;

				resultImg[i][3 * j] = unsigned char(red);
				resultImg[i][3 * j + 1] = unsigned char(green);
				resultImg[i][3 * j + 2] = unsigned char(blue);
			}
		}
	}
}

#include <vector>
#include <algorithm>
using namespace std;

void CImageProch3Doc::RegionMedian()
{
	for (int i = 1; i < imageHeight - 1; ++i) {
		for (int j = 1; j < imageWidth - 1; ++j) {
			if (depth == 1) {
				vector<int> v;
				v.reserve(9);

				for (int p = -1; p <= 1; ++p) {
					for (int q = -1; q <= 1; ++q)
						v.emplace_back(inputImg[i + p][j + q]);
				}

				sort(v.begin(), v.end());
				resultImg[i][j] = v[4];
			}
			else if (depth == 3) {
				vector<int> v_r, v_g, v_b;
				v_r.reserve(9);
				v_g.reserve(9);
				v_b.reserve(9);

				for (int p = -1; p <= 1; ++p) {
					for (int q = -1; q <= 1; ++q) {
						v_r.emplace_back(inputImg[i + p][3 * (j + q)]);
						v_g.emplace_back(inputImg[i + p][3 * (j + q) + 1]);
						v_b.emplace_back(inputImg[i + p][3 * (j + q) + 2]);
					}
				}

				sort(v_r.begin(), v_r.end());
				sort(v_g.begin(), v_g.end());
				sort(v_b.begin(), v_b.end());
				resultImg[i][3 * j] = v_r[4];
				resultImg[i][3 * j + 1] = v_g[4];
				resultImg[i][3 * j + 2] = v_b[4];
			}
		}
	}
}

void CImageProch3Doc::RegionEmbossing()
{
	double kernel[3][3] = { {-1, 0, 0},
							{0, 0, 0},
							{0, 0, 1} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 128, depth);
}

void CImageProch3Doc::RegionLog()
{
	double kernel[3][3] = { {0, 1, 0},
							{1, -4, 1},
							{0, 1, 0} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 0, depth);
}

void CImageProch3Doc::RegionLog2()
{
	double kernel[3][3] = { {1, 1, 1},
							{1, -8, 1},
							{1, 1, 1} };

	Convolve(inputImg, resultImg, imageWidth, imageHeight, kernel, 0, depth);
}

void CImageProch3Doc::Erosion()
{
	for (int i = 1; i < imageHeight - 1; ++i) {
		for (int j = 1; j < imageWidth - 1; ++j) {
			int min_val = 255;

			for (int y = -1; y <= 1; ++y) {
				for (int x = -1; x <= 1; ++x) {
					if (min_val > inputImg[i + y][j + x])
						min_val = inputImg[i + y][j + x];
				}
			}

			resultImg[i][j] = min_val;
		}
	}
}

void CImageProch3Doc::Dilation()
{
	for (int i = 1; i < imageHeight - 1; ++i) {
		for (int j = 1; j < imageWidth - 1; ++j) {
			int max_val = 0;

			for (int y = -1; y <= 1; ++y) {
				for (int x = -1; x <= 1; ++x) {
					if (max_val < inputImg[i + y][j + x])
						max_val = inputImg[i + y][j + x];
				}
			}

			resultImg[i][j] = max_val;
		}
	}
}

void CImageProch3Doc::Opening()
{
	for (int i = 0; i < 3; ++i) {
		Erosion();
		CopyResultToInput();
	}

	for (int i = 0; i < 3; ++i) {
		Dilation();

		if (i != 2)
			CopyResultToInput();
	}
}

void CImageProch3Doc::Closing()
{
	for (int i = 0; i < 3; ++i) {
		Dilation();
		CopyResultToInput();
	}

	for (int i = 0; i < 3; ++i) {
		Erosion();

		if (i != 2)
			CopyResultToInput();
	}
}

void CImageProch3Doc::CopyResultToInput()
{
	for (int i = 0; i < imageHeight; ++i) {
		for (int j = 0; j < imageWidth; ++j)
			inputImg[i][j] = resultImg[i][j];
	}
}

BOOL CImageProch3Doc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: 여기에 재초기화 코드를 추가합니다.
	// SDI 문서는 이 문서를 다시 사용합니다.

	return TRUE;
}




// CImageProch3Doc serialization

void CImageProch3Doc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: 여기에 저장 코드를 추가합니다.
	}
	else
	{
		// TODO: 여기에 로딩 코드를 추가합니다.
		LoadImageFile(ar);
	}
}

#ifdef SHARED_HANDLERS

// 축소판 그림을 지원합니다.
void CImageProch3Doc::OnDrawThumbnail(CDC& dc, LPRECT lprcBounds)
{
	// 문서의 데이터를 그리려면 이 코드를 수정하십시오.
	dc.FillSolidRect(lprcBounds, RGB(255, 255, 255));

	CString strText = _T("TODO: implement thumbnail drawing here");
	LOGFONT lf;

	CFont* pDefaultGUIFont = CFont::FromHandle((HFONT) GetStockObject(DEFAULT_GUI_FONT));
	pDefaultGUIFont->GetLogFont(&lf);
	lf.lfHeight = 36;

	CFont fontDraw;
	fontDraw.CreateFontIndirect(&lf);

	CFont* pOldFont = dc.SelectObject(&fontDraw);
	dc.DrawText(strText, lprcBounds, DT_CENTER | DT_WORDBREAK);
	dc.SelectObject(pOldFont);
}

// 검색 처리기를 지원합니다.
void CImageProch3Doc::InitializeSearchContent()
{
	CString strSearchContent;
	// 문서의 데이터에서 검색 콘텐츠를 설정합니다.
	// 콘텐츠 부분은 ";"로 구분되어야 합니다.

	// 예: strSearchContent = _T("point;rectangle;circle;ole object;");
	SetSearchContent(strSearchContent);
}

void CImageProch3Doc::SetSearchContent(const CString& value)
{
	if (value.IsEmpty())
	{
		RemoveChunk(PKEY_Search_Contents.fmtid, PKEY_Search_Contents.pid);
	}
	else
	{
		CMFCFilterChunkValueImpl *pChunk = nullptr;
		ATLTRY(pChunk = new CMFCFilterChunkValueImpl);
		if (pChunk != nullptr)
		{
			pChunk->SetTextValue(PKEY_Search_Contents, value, CHUNK_TEXT);
			SetChunkValue(pChunk);
		}
	}
}

#endif // SHARED_HANDLERS

// CImageProch3Doc 진단

#ifdef _DEBUG
void CImageProch3Doc::AssertValid() const
{
	CDocument::AssertValid();
}

void CImageProch3Doc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CImageProch3Doc 명령

void CImageProch3Doc::LoadTwoImages()
{
	CFileDialog dlg(TRUE);

	AfxMessageBox(_T("Select the First Image"));

	if (dlg.DoModal() == IDOK) {
		CFile file;

		if (file.Open(dlg.GetPathName(), CFile::modeRead) != 0) {
			CArchive ar(&file, CArchive::load);
			LoadImageFile(ar);
			file.Close();
		}
	}

	AfxMessageBox(_T("Select the Second Image"));

	if (dlg.DoModal() == IDOK) {
		CFile file;

		if (file.Open(dlg.GetPathName(), CFile::modeRead) != 0) {
			CArchive ar(&file, CArchive::load);
			LoadSecondImageFile(ar);
			file.Close();
		}
	}
}

void CImageProch3Doc::LoadSecondImageFile(CArchive& ar)
{
	CFile* fp = ar.GetFile();
	CString fname = fp->GetFilePath();

	char type[16], buf[256];
	int maxValue;

	if (strcmp(strrchr(fname, '.'), ".ppm") == 0 ||
		strcmp(strrchr(fname, '.'), ".PPM") == 0 ||
		strcmp(strrchr(fname, '.'), ".pgm") == 0 ||
		strcmp(strrchr(fname, '.'), ".PGM") == 0) {
		ar.ReadString(type, 15);

		do {
			ar.ReadString(buf, 255);
		} while (buf[0] == '#');

		sscanf_s(buf, "%d %d", &imageWidth, &imageHeight);

		do {
			ar.ReadString(buf, 255);
		} while (buf[0] == '#');

		sscanf_s(buf, "%d", &maxValue);

		if (strcmp(type, "P5") == 0)
			depth = 1;
		else
			depth = 3;
	}
	else if (strcmp(strrchr(fname, '.'), ".raw") == 0 ||
		strcmp(strrchr(fname, '.'), ".RAW") == 0) {
		if (fp->GetLength() != 256 * 256) {
			AfxMessageBox("256x256 크기의 파일만 사용가능합니다.");
			return;
		}

		imageWidth = 256;
		imageHeight = 256;
		depth = 1;
	}

	inputImg2 = (unsigned char**)malloc(imageHeight * sizeof(unsigned char*));

	for (int i = 0; i < imageHeight; ++i)
		inputImg2[i] = (unsigned char*)malloc(imageWidth * depth);

	for (int i = 0; i < imageHeight; ++i)
		ar.Read(inputImg2[i], imageWidth * depth);
}
