﻿
// ImagePro_ch3Doc.h: CImageProch3Doc 클래스의 인터페이스
//


#pragma once


class CImageProch3Doc : public CDocument
{
protected: // serialization에서만 만들어집니다.
	CImageProch3Doc() noexcept;
	DECLARE_DYNCREATE(CImageProch3Doc)

// 특성입니다.
public:
	unsigned char** inputImg{ nullptr };
	unsigned char** inputImg2{ nullptr };
	unsigned char** resultImg{ nullptr };
	int imageWidth;
	int imageHeight;
	int depth;
	 
// 작업입니다.
public:
	void LoadImageFile(CArchive& ar);
	void PixelAdd();
	void PixelHistoEq();
	void PixelStretchIntensity();
	void PixelTwoImageAdd();
	void PixelTwoImageSubtract();
	void PixelTwoImageSubtract_security();
	void PixelTwoImageMultiply();
	void PixelTwoImageDivide();
	void LoadTwoImages();
	void LoadSecondImageFile(CArchive&);
	void PixelBinary();
	void PixelReverse();

	void RegionSharpening();
	void Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][3], int bias, int depth);
	void Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][2], int bias, int depth);
	void Convolve(unsigned char** inputImg, unsigned char** resultImg, int cols, int rows, double mask[][5], int bias, int depth);
	void RegionMeaning();
	void RegionMedian5x5();
	void RegionSobel();
	void RegionPrewitt();
	void RegionRoberts();
	void RegionMedian();
	void RegionEmbossing();
	void RegionLog();
	void RegionLog2();

	void Erosion();
	void Dilation();
	void Opening();
	void Closing();
	void CopyResultToInput();

// 재정의입니다.
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
#ifdef SHARED_HANDLERS
	virtual void InitializeSearchContent();
	virtual void OnDrawThumbnail(CDC& dc, LPRECT lprcBounds);
#endif // SHARED_HANDLERS

// 구현입니다.
public:
	virtual ~CImageProch3Doc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// 생성된 메시지 맵 함수
protected:
	DECLARE_MESSAGE_MAP()

#ifdef SHARED_HANDLERS
	// 검색 처리기에 대한 검색 콘텐츠를 설정하는 도우미 함수
	void SetSearchContent(const CString& value);
#endif // SHARED_HANDLERS
};
