﻿
// ImagePro_ch3View.cpp: CImageProch3View 클래스의 구현
//

#include "pch.h"
#include "framework.h"
// SHARED_HANDLERS는 미리 보기, 축소판 그림 및 검색 필터 처리기를 구현하는 ATL 프로젝트에서 정의할 수 있으며
// 해당 프로젝트와 문서 코드를 공유하도록 해 줍니다.
#ifndef SHARED_HANDLERS
#include "ImagePro_ch3.h"
#endif

#include "ImagePro_ch3Doc.h"
#include "ImagePro_ch3View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define TWO_IMAGES		1
#define THREE_IMAGES	2

// CImageProch3View

IMPLEMENT_DYNCREATE(CImageProch3View, CView)

BEGIN_MESSAGE_MAP(CImageProch3View, CView)
	// 표준 인쇄 명령입니다.
	ON_COMMAND(ID_FILE_PRINT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CImageProch3View::OnFilePrintPreview)
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_PIXEL_ADD, &CImageProch3View::OnPixelAdd)
	ON_COMMAND(ID_PIXEL_HISTO_EQ, &CImageProch3View::OnPixelHistoEq)
	ON_COMMAND(ID_PIXEL_TWO_IMAGE_ADD, &CImageProch3View::OnPixelTwoImageAdd)
	ON_COMMAND(ID_REGION_SHARPENING, &CImageProch3View::OnRegionSharpening)
	ON_COMMAND(ID_REGION_MEANING, &CImageProch3View::OnRegionMeaning)
	ON_COMMAND(ID_REGION_SOBEL, &CImageProch3View::OnRegionSobel)
	ON_COMMAND(ID_REGION_MEDIAN, &CImageProch3View::OnRegionMedian)
	ON_COMMAND(ID_REGION_PREWITT, &CImageProch3View::OnRegionPrewitt)
	ON_COMMAND(ID_REGION_ROBERTS, &CImageProch3View::OnRegionRoberts)
	ON_COMMAND(ID_REGION_MEDIAN_5X5, &CImageProch3View::OnRegionMedian5x5)
	ON_COMMAND(ID_REGION_EMBOSSING, &CImageProch3View::OnRegionEmbossing)
	ON_COMMAND(ID_REGION_LOG, &CImageProch3View::OnRegionLog)
	ON_COMMAND(ID_REGION_LOG_2, &CImageProch3View::OnRegionLog2)
	ON_COMMAND(ID_EROSION, &CImageProch3View::OnErosion)
	ON_COMMAND(ID_DILATION, &CImageProch3View::OnDilation)
	ON_COMMAND(ID_OPENING, &CImageProch3View::OnOpening)
	ON_COMMAND(ID_CLOSING, &CImageProch3View::OnClosing)
END_MESSAGE_MAP()

// CImageProch3View 생성/소멸

CImageProch3View::CImageProch3View() noexcept
{
	// TODO: 여기에 생성 코드를 추가합니다.

}

CImageProch3View::~CImageProch3View()
{
}

BOOL CImageProch3View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: CREATESTRUCT cs를 수정하여 여기에서
	//  Window 클래스 또는 스타일을 수정합니다.

	return CView::PreCreateWindow(cs);
}

// CImageProch3View 그리기

void CImageProch3View::OnDraw(CDC* pDC)
{
	CImageProch3Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: 여기에 원시 데이터에 대한 그리기 코드를 추가합니다.
	if (pDoc->inputImg == NULL) return;

	if (pDoc->depth == 1) {
		for (int i = 0; i < pDoc->imageHeight; ++i) {
			for (int j = 0; j < pDoc->imageWidth; ++j)
				pDC->SetPixel(j, i, RGB(pDoc->inputImg[i][j], pDoc->inputImg[i][j], pDoc->inputImg[i][j]));
		}

		if (viewMode == THREE_IMAGES) {
			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth + 30, i, RGB(pDoc->inputImg2[i][j], pDoc->inputImg2[i][j], pDoc->inputImg2[i][j]));
			}

			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth * 2 + 60, i, RGB(pDoc->resultImg[i][j], pDoc->resultImg[i][j], pDoc->resultImg[i][j]));
			}
		}
		else {
			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth + 30, i, RGB(pDoc->resultImg[i][j], pDoc->resultImg[i][j], pDoc->resultImg[i][j]));
			}
		}
	}
	else if (pDoc->depth == 3) {
		for (int i = 0; i < pDoc->imageHeight; ++i) {
			for (int j = 0; j < pDoc->imageWidth; ++j)
				pDC->SetPixel(j, i, RGB(pDoc->inputImg[i][3 * j], pDoc->inputImg[i][3 * j + 1], pDoc->inputImg[i][3 * j + 2]));
		}

		if (viewMode == THREE_IMAGES) {
			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth + 30, i, RGB(pDoc->inputImg2[i][3 * j], pDoc->inputImg2[i][3 * j + 1], pDoc->inputImg2[i][3 * j + 2]));
			}

			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth * 2 + 60, i, RGB(pDoc->resultImg[i][3 * j], pDoc->resultImg[i][3 * j + 1], pDoc->resultImg[i][3 * j + 2]));
			}
		}
		else {
			for (int i = 0; i < pDoc->imageHeight; ++i) {
				for (int j = 0; j < pDoc->imageWidth; ++j)
					pDC->SetPixel(j + pDoc->imageWidth + 30, i, RGB(pDoc->resultImg[i][3 * j], pDoc->resultImg[i][3 * j + 1], pDoc->resultImg[i][3 * j + 2]));
			}
		}
	}
}


// CImageProch3View 인쇄


void CImageProch3View::OnFilePrintPreview()
{
#ifndef SHARED_HANDLERS
	AFXPrintPreview(this);
#endif
}

BOOL CImageProch3View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// 기본적인 준비
	return DoPreparePrinting(pInfo);
}

void CImageProch3View::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: 인쇄하기 전에 추가 초기화 작업을 추가합니다.
}

void CImageProch3View::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: 인쇄 후 정리 작업을 추가합니다.
}

void CImageProch3View::OnRButtonUp(UINT /* nFlags */, CPoint point)
{
	ClientToScreen(&point);
	OnContextMenu(this, point);
}

void CImageProch3View::OnContextMenu(CWnd* /* pWnd */, CPoint point)
{
#ifndef SHARED_HANDLERS
	theApp.GetContextMenuManager()->ShowPopupMenu(IDR_POPUP_EDIT, point.x, point.y, this, TRUE);
#endif
}


// CImageProch3View 진단

#ifdef _DEBUG
void CImageProch3View::AssertValid() const
{
	CView::AssertValid();
}

void CImageProch3View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CImageProch3Doc* CImageProch3View::GetDocument() const // 디버그되지 않은 버전은 인라인으로 지정됩니다.
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CImageProch3Doc)));
	return (CImageProch3Doc*)m_pDocument;
}
#endif //_DEBUG


// CImageProch3View 메시지 처리기


void CImageProch3View::OnPixelAdd()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	if (pDoc->inputImg == NULL)
		return;

	pDoc->PixelAdd();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnPixelHistoEq()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	if (pDoc->inputImg == NULL)
		return;

	pDoc->PixelHistoEq();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnPixelTwoImageAdd()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc)
		return;

	pDoc->PixelTwoImageAdd();
	viewMode = THREE_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionSharpening()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionSharpening();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionMeaning()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionMeaning();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionSobel()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionSobel();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionMedian()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionMedian();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionPrewitt()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionPrewitt();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionRoberts()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionRoberts();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionMedian5x5()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionMedian5x5();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionEmbossing()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionEmbossing();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionLog()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionLog();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnRegionLog2()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->RegionLog2();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnErosion()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->Erosion();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnDilation()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->Dilation();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnOpening()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->Opening();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}


void CImageProch3View::OnClosing()
{
	// TODO: 여기에 명령 처리기 코드를 추가합니다.
	CImageProch3Doc* pDoc = GetDocument();

	ASSERT_VALID(pDoc);

	if (!pDoc) return;
	if (pDoc->inputImg == NULL) return;

	pDoc->Closing();
	viewMode = TWO_IMAGES;
	Invalidate(FALSE);
}
